****************************************************************************
***
*** EJEMPLO2.PRG - 2 ejemplo del uso de las funciones del API de Windows
***                sobre manejo de ficheros .INI
***
***        Pablo Almunia Sanz
***        100341.1136@compuserve.com
***
****************************************************************************
****************************************************************************
*** Este programa es de libre distibucin. El autor no se compromente a
*** a ningn tipo de soporte sobre el cdigo o su uso. El autor no es
*** responsable del uso que se pueda hacer del cdigo, de los errores que
*** pueda contener o de la perdida o destruccin de datos que puedan ser
*** causados por el mismo.
****************************************************************************

*** Cargar la Form y mostrarla ***
PUBLIC oEjemplo2
oEjemplo2 = CREATEOBJECT( "Ejemplo2" )
oEjemplo2.Show()
RETURN

*** Form del ejemplo en forma de clase ***
DEFINE CLASS Ejemplo2 AS form

  BackColor = RGB(192,192,192)
  Caption = "Ejemplo 2 sobre INIs"

  *** Botn para cerrar ***
  ADD OBJECT cmdAceptar ;
    AS COMMANDBUTTON WITH ;
    Top = 6, ;
    Left = 6, ;
    Height = 29, ;
    Width = 94, ;
    Caption = "Aceptar"

  *** Evento al crear la form ***
  PROCEDURE Load

    *** Cargar las declaraciones ***
    DO profiles

    *** Obtener los valores con ***
    *** los que se cerr la ltima vez ***
    WITH This
      .Top    = GetPrivateProfileInt( ;
                  "Ejemplo 2", ;
                  "Top", ;
                  .Top, ;
                  "ejemplos.ini" )
      .Left   = GetPrivateProfileInt( ;
                  "Ejemplo 2", ;
                  "Left", ;
                  .Left, ;
                  "ejemplos.ini" )
      .Width  = GetPrivateProfileInt( ;
                  "Ejemplo 2", ;
                  "Width", ;
                  .Width, ;
                  "ejemplos.ini" )
      .Height = GetPrivateProfileInt( ;
                  "Ejemplo 2", ;
                  "Height", ;
                  .Height, ;
                  "ejemplos.ini" )
    ENDWITH
  ENDPROC

  *** Evento al destruir la form ***
  PROCEDURE Unload

    *** Cargar las declaraciones ***
    *** pueden haberse descargado ***
    DO profiles

    *** Si est minimizado o maximizado ***
    *** restaurar al tamao normal ***
    This.WindowState = 0

    *** Guardar los valores de ***
    *** posicin y tamao ***
    WITH This
      = WritePrivateProfileString( ;
          "Ejemplo 2", ;
          "Top", ;
          LTRIM( STR( .Top ) ), ;
          "ejemplos.ini" )
      = WritePrivateProfileString( ;
          "Ejemplo 2", ;
          "Left", ;
          LTRIM( STR( .Left ) ), ;
          "ejemplos.ini" )
      = WritePrivateProfileString( ;
          "Ejemplo 2", ;
          "Width", ;
          LTRIM( STR( .Width ) ), ;
          "ejemplos.ini" )
      = WritePrivateProfileString( ;
          "Ejemplo 2", ;
          "Height", ;
          LTRIM( STR( .Height ) ), ;
          "ejemplos.ini" )
    ENDWITH
  ENDPROC

  *** Mtodo para cerrar la form ***
  PROCEDURE cmdAceptar.Click
    ThisForm.Release()
  ENDPROC

ENDDEFINE


*** Fin de EJEMPLO2.PRG ***